---
Difficulty: Easy  
Source: Daily-Question (POTD 2-Dec)  
Tags:
- Two Pointers
- String
- String Matching
---

# 🚀 *1455 - Check If a Word Occurs As a Prefix of Any Word in a Sentence* 🧠

### Problem Link:
[**LeetCode - Check If a Word Occurs As a Prefix of Any Word in a Sentence**](https://leetcode.com/problems/check-if-a-word-occurs-as-a-prefix-of-any-word-in-a-sentence/description/?envType=daily-question&envId=2024-12-02)

## 💡 **Problem Breakdown:**

You are given a sentence consisting of words separated by a space and a searchWord. Your task is to determine if the `searchWord` is a prefix of any word in the sentence.

If the `searchWord` is a prefix of any word in the sentence, return the 1-indexed position of the first such word. If no such word exists, return `-1`.

## 🔍 **Example Walkthrough:**

### Example 1:

**Input:**  
`sentence = "i love eating burger", searchWord = "burg"`  
**Output:**  
`4`

**Explanation:**  
"burg" is a prefix of "burger", which is the 4th word in the sentence.

### Example 2:

**Input:**  
`sentence = "this problem is an easy problem", searchWord = "pro"`  
**Output:**  
`2`

**Explanation:**  
"pro" is a prefix of "problem" which appears at positions 2 and 6, but we return 2 as it's the first occurrence.

### Example 3:

**Input:**  
`sentence = "i am tired", searchWord = "you"`  
**Output:**  
`-1`

**Explanation:**  
No word in the sentence starts with "you", so we return `-1`.


## 🎯 **My Approach:**

This problem can be approached using the following steps:

1. **Split the Sentence**:  
   Split the sentence into words based on spaces. This will give us a list of individual words to check.
   
2. **Check Prefix**:  
   For each word, check if the `searchWord` is a prefix using the `startswith` function (or an equivalent).

3. **Return the Index**:  
   If a word is found that starts with the `searchWord`, return its 1-based index. If no such word is found after checking all, return `-1`.

## 🕒 **Time Complexity:**
- **O(m * n)**, where:
  - `m` is the number of words in the sentence (approximately the number of words).
  - `n` is the average length of each word.
  
  We iterate over each word in the sentence and check if the `searchWord` is a prefix of it. Checking if a word starts with another string takes O(n) time where `n` is the length of the `searchWord`.

- **Space Complexity:**
  - **O(m)**: We store the words in the sentence, where `m` is the number of words in the sentence.

## 📝 **Solution Code**

## Code (C):

```c
int isPrefixOfWord(char* sentence, char* searchWord) {
    int wordIndex = 1; 
    char* word = strtok(sentence, " "); 

    while (word != NULL) {
        if (strncmp(word, searchWord, strlen(searchWord)) == 0) {
            return wordIndex;
        }
        wordIndex++;
        word = strtok(NULL, " ");
    }

    return -1; 
}
```

## Code (C++):

```cpp
class Solution {
public:
    int isPrefixOfWord(string sentence, string searchWord) {
        istringstream iss(sentence); 
        string word;
        int wordIndex = 1;
        while (iss >> word) { 
            if (word.find(searchWord) == 0) { 
                return wordIndex;
            }
            wordIndex++;
        }
        return -1; 
    }
};
```

## Code (Java):

```java
class Solution {
    public int isPrefixOfWord(String sentence, String searchWord) {
        String[] words = sentence.split(" "); 
        for (int i = 0; i < words.length; i++) {
            if (words[i].startsWith(searchWord)) { 
                return i + 1; 
            }
        }
        return -1; 
    }
}
```

## Code (Python):

```python
class Solution:
    def isPrefixOfWord(self, sentence: str, searchWord: str) -> int:
        for i, word in enumerate(sentence.split(), 1):
            if word.startswith(searchWord):  
                return i
        return -1  
```

## Code (Rust):

```rust
impl Solution {
    pub fn is_prefix_of_word(sentence: String, search_word: String) -> i32 {
        sentence.split_whitespace()
            .enumerate()
            .find(|(_, word)| word.starts_with(&search_word))
            .map_or(-1, |(i, _)| (i + 1) as i32)
    }
}
```



## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
